--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: Sydney
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "syd_factorykeep" }
DefineCharacter { name = "syd_marketkeep" }
DefineCharacter { name = "syd_shopkeep" }
DefineCharacter { name = "syd_other1keep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "sydney",
	available = false,
	ambient="sfx/seaside_loop.ogg",
	
	layout =
	{
		-- Clouds
		SpriteLayer { image="clouds_02", time=130000, loop=true, htile=true, path={{800,90},{700,90},{100,90},{0,90}}, },
		
		-- Planes
		SpriteLayer { imagelist=portPlanes, scale=.4, time=9000,hold=5000,bounce=true,
			path={{-94,37},{100,70},{451,52},{886,87},}, },
		
		EmptyBuilding { name="syd_bridge", x=0+373/2,y=0+233/2, startweek = 362 },  -- 1932
	
		Factory { name="syd_factory", character="syd_factorykeep", price = 3150000, x=364+122/2,y=168+51/2 },
		PlayerLogo { name="logo", x=376+101/2,y=132+58/2, scale=0.291, target="syd_factory" },
		
		-- Ships, etc
		SpriteLayer { imagelist=portBoats, scale=.25, time=43000,bounce=true,
			path={{-37,271},{104,278},{750,280},{880,257},}, },
		
		SpriteLayer { image="syd_bgbuildings", x=574,y=225, },
		EmptyBuilding { name="syd_other2", character={"syd_other2keep"}, ambient="sfx/other_loop.ogg", x=548+80/2,y=0+304/2, startweek = 733 }, --1939
		

		Market { name="syd_market", character="syd_marketkeep", x=227+200/2,y=221+98/2,
			inventory = { macadamia=true, cherry=true, milk=true, raspberry=true, sugar=true, orange=true} },
		SpriteLayer { image="syd_marketmask", x=227+207/2,y=292+62/2, },
			
		-- Cars
		SpriteLayer { imagelist=portCars, scale=.35, time=20000,bounce=true,
			path={{-80,300},{530,300},{580,300},{880,300}} },

		SpriteLayer { imagelist=portCars, scale=.35, time=19000,bounce=true,
			path={{880,303},{580,303},{530,303},{-80,303},} },
		
		Shop { name="syd_shop", character="syd_shopkeep", x=137,y=258, labelx=50,labely=220 },
		SpriteLayer { image="syd_rightmask", x=606+194/2,y=0+323/2 },
		
		-- cars

		GenericBuilding { name="syd_other1", character="syd_other1keep", ambient="sfx/other_loop.ogg", x=682+118/2,y=0+396/2},
	},
}
